# バッチ設計書 12-npm run test-e2e-cov

## 概要

本ドキュメントは、three.jsプロジェクトにおけるexamplesのスクリーンショットおよびfiles.jsonカバレッジチェックバッチ `npm run test-e2e-cov` の設計仕様を定義する。

### 本バッチの処理概要

examplesディレクトリ内のHTMLファイルが、スクリーンショットとfiles.jsonの両方に適切に登録されているかを検証するカバレッジチェックバッチである。examples、screenshots、files.jsonの3つの集合を比較し、過不足を検出する。

**業務上の目的・背景**：three.jsプロジェクトでは、新しいexampleを追加する際に、スクリーンショットの生成とfiles.jsonへの登録が必須となっている。このバッチは、リリース前にすべてのexampleが正しく管理されていることを保証するために存在する。スクリーンショットが欠落していると E2Eテストが失敗し、files.jsonへの登録が欠落しているとexamplesページのインデックスに表示されない問題が発生する。

**バッチの実行タイミング**：PRトリガーで自動実行（GitHub Actions CI）、または開発者によるローカル環境での手動実行。CI環境ではtestジョブの一部として実行される。

**主要な処理内容**：
1. examples/ディレクトリからHTMLファイル一覧（E）を取得
2. examples/screenshots/ディレクトリからスクリーンショット一覧（S）を取得
3. examples/files.jsonから登録済みexample一覧（F）を取得
4. E - S（スクリーンショット未作成）を検出
5. S - E（不要なスクリーンショット）を検出
6. E - F（files.json未登録）を検出
7. F - E（不要なfiles.json登録）を検出

**前後の処理との関連**：CIではLintテスト、単体テスト、単体テスト（addons）の後に実行される。このテストに失敗するとPRがマージできない。

**影響範囲**：examples/ディレクトリ、examples/screenshots/ディレクトリ、examples/files.json

## バッチ種別

カバレッジチェック / 整合性検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（PRごと、手動実行） |
| 実行時刻 | 不定 |
| 実行曜日 | 不定 |
| 実行日 | 不定 |
| トリガー | PRイベント / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js 24以上がインストールされていること |
| 依存パッケージ | `npm ci`による依存関係のインストール完了 |
| examplesディレクトリ | examples/ディレクトリが存在すること |
| screenshotsディレクトリ | examples/screenshots/ディレクトリが存在すること |
| files.json | examples/files.jsonが存在すること |

### 実行可否判定

- examples/ディレクトリにHTMLファイルが存在すること
- examples/files.jsonが有効なJSONファイルであること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| examples/*.html | HTMLファイル | example一覧の取得元 |
| examples/screenshots/*.jpg | JPEGファイル | スクリーンショット一覧の取得元 |
| examples/files.json | JSONファイル | exampleのカテゴリ分類と登録情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| stdout | テキスト | テスト結果のコンソール出力 |
| 終了コード | 数値 | 0=成功、1=失敗 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. examples一覧取得
   └─ examples/ディレクトリから.htmlファイルを列挙（index.htmlを除外）

2. screenshots一覧取得
   └─ examples/screenshots/ディレクトリからファイルを列挙

3. files.json読み込み
   └─ JSONをパースしてexample名の配列を構築

4. 集合演算による差分検出
   └─ E-S, S-E, E-F, F-Eの各差分を計算

5. 結果判定・出力
   └─ 差分がなければ成功、あれば詳細を出力して失敗
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[examples/からHTMLファイル一覧取得]
    B --> C[examples/screenshots/からファイル一覧取得]
    C --> D[examples/files.jsonを読み込み]
    D --> E[E - S を計算<br>スクリーンショット未作成]
    E --> F[S - E を計算<br>不要なスクリーンショット]
    F --> G[E - F を計算<br>files.json未登録]
    G --> H[F - E を計算<br>不要なfiles.json登録]
    H --> I{差分あり?}
    I -->|Yes| J[エラーメッセージ出力]
    J --> K[exit code 1で終了]
    I -->|No| L[成功メッセージ出力]
    L --> M[exit code 0で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | スクリーンショット未作成 | E - S が空でない | `npm run make-screenshot {example名}`で生成 |
| - | 不要スクリーンショット | S - E が空でない | 対象ファイルを削除 |
| - | files.json未登録 | E - F が空でない | files.jsonにexampleを追加 |
| - | 不要files.json登録 | F - E が空でない | files.jsonから該当エントリを削除 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージで具体的なexample名が出力される
2. メッセージに従って対応（スクリーンショット生成、ファイル削除、files.json編集）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約300-400 examples |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限（ファイル一覧のみ保持） |

## 排他制御

- 同時実行に関する制約なし（読み取り専用処理）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 成功ログ | 全チェック成功時 | "TEST PASSED! All examples is covered with screenshots and descriptions in files.json!" |
| エラーログ | スクリーンショット未作成 | "Make screenshot for example(s): {example名}" |
| エラーログ | 不要スクリーンショット | "Remove unnecessary screenshot(s): {example名}" |
| エラーログ | files.json未登録 | "Add description in files.json for example(s): {example名}" |
| エラーログ | 不要files.json登録 | "Remove description in files.json for example(s): {example名}" |
| 終了ログ | テスト失敗時 | "TEST FAILED!" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト結果 | 失敗時 | GitHub Actions PR check |

## 備考

- このテストはCI環境の「test」ジョブで「Examples ready for release」ステップとして実行される
- 非常に高速に実行される（ファイルシステムの読み取りのみ）
- 新規exampleを追加した場合は、このテストが失敗することで作業漏れを検出できる
